#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// foldable cubeMod01.fsh  by  ShnitzelKiller
//https://www.shadertoy.com/view/wllXDM
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


#define ITERS 100
#define TOL 1e-3
#define fdist 0.5
#define maxdist 100.
#define LEVELS 7
#define PI 3.1415926

float noise(in vec2 uv)
{
	return fract(sin(dot(vec2(1484191., 189159.), uv))*9991415.);   
}

vec4 map(in vec3 pos)   
{
    float t = (clamp(abs(mod(iTime*0.25, 6.0) - 3.0), 1.0, 2.0)-1.0) * PI * 0.5;
    if (iMouse.w > 1.0)
    {
    	t = iMouse.y/iResolution.y*PI*0.5;
    }
    float c = cos(t);
    float s = sin(t);
    mat3 rotZ = mat3(c, -s, 0, s, c, 0, 0, 0, 1);
    mat3 rotX = mat3(1, 0, 0, 0, c, -s, 0, s, c);
    float sc = 0.5;
    for (int i=0; i<LEVELS; i++)
    {
        pos = abs(rotX * rotZ * pos) - sc;
     	sc *= 0.5;
    }
    
    return vec4(max(pos.x, max(pos.y, pos.z))-sc*2., pos);
}

vec4 march(in vec3 pos, in vec3 dir, in vec2 seed)
{
    float t = 0.;
    vec4 dist;
    for (int i=0; i<ITERS; i++)
    {
        vec3 currpos = t*dir+pos;
    	dist = map(currpos);
        t += dist.x * (1.+(noise(seed)-0.5)*0.5);
        seed.x += dist.x;
        if (abs(dist.x) < TOL)
        {
            return vec4(i, dist.yzw);
        } else if (t > maxdist) {
            return vec4(i, dist.yzw);
        }
    }
    return vec4(ITERS, dist.yzw);
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float c = cos(iTime);
    float s = sin(iTime);
    mat3 rot = mat3(c, -s, 0, s, c, 0, 0, 0, 1);
    vec2 uv = (fragCoord-iResolution.xy*0.5)/iResolution.x;
    vec3 ro = rot * vec3(1.,1.,1.) * (2.+s*0.3);
    vec3 nw = -normalize(ro);
    vec3 up = vec3(0.,0.,1.);
    vec3 nu = cross(nw, up);
    vec3 nv = cross(nu, nw);
   	vec3 rd = normalize(nw*fdist + uv.x*nu + uv.y*nv);
    vec4 d = march(ro, rd, uv);
    fragColor = vec4(d.x/float(ITERS)*2. * (normalize(d.yzw)+1.)*0.5,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

